/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/healthcheck")
public class HealthCheckResource {
    private static final Logger s_logger = LoggerFactory.getLogger(HealthCheckResource.class);

    @GET
    public Response doHealthCheck() {
        try {
            InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
            switch (myInfo.getStatus()) {
                case UP: {
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                case STARTING: {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                case OUT_OF_SERVICE: {
                    return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                }
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Throwable th) {
            s_logger.error("Error doing healthceck", th);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

