/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#include "AMT_SOAPEventSubscriber.h"
using namespace CimClassNamespace;

AMT_SOAPEventSubscriber::AMT_SOAPEventSubscriber(
		const string& objName,
		const string& uri,
		const string& ns,
		const string& nsPrefix)
		:AMT_EventSubscriber(objName, uri, ns, nsPrefix),
		AccessContextSpecified(false),
		OtherAccessContextSpecified(false),
		UserNameSpecified(false),
		PasswordSpecified(false){}

void  AMT_SOAPEventSubscriber::SerializeMembers(XMLElement& node) const
{
	if(AccessContextSpecified)
	{
		node.AppendLeaf("AccessContext", AccessContext, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("AccessInfo", AccessInfo, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	node.AppendLeafArray("AlertAuthenticationOptions", AlertAuthenticationOptions, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	node.AppendLeaf("CreationClassName", CreationClassName, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	if(ElementNameSpecified)
	{
		node.AppendLeaf("ElementName", ElementName, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	if(EnabledStateSpecified)
	{
		node.AppendLeaf("EnabledState", EnabledState, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	if(InfoFormatSpecified)
	{
		node.AppendLeaf("InfoFormat", InfoFormat, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("Name", Name, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	if(OtherAccessContextSpecified)
	{
		node.AppendLeaf("OtherAccessContext", OtherAccessContext, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	if(PasswordSpecified)
	{
		node.AppendLeaf("Password", Password, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("PolicyID", PolicyID, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	if(PortProtocolSpecified)
	{
		node.AppendLeaf("PortProtocol", PortProtocol, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	if(PortInfoSpecified)
	{
		node.AppendLeaf("PortInfo", PortInfo, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	if(RequestedStateSpecified)
	{
		node.AppendLeaf("RequestedState", RequestedState, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("SystemCreationClassName", SystemCreationClassName, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	node.AppendLeaf("SystemName", SystemName); //, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	if(UserNameSpecified)
	{
		node.AppendLeaf("UserName", UserName, AMT_SOAPEventSubscriber::CLASS_URI, AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);
	}
}

NameValuePairs AMT_SOAPEventSubscriber::GetSelectorsList() const
{
	NameValuePairs serList;
	serList["CreationClassName"] = XMLTypeConverter::TypeToString(CreationClassName);
	serList["Name"] = XMLTypeConverter::TypeToString(Name);
	serList["SystemCreationClassName"] = XMLTypeConverter::TypeToString(SystemCreationClassName);
	serList["SystemName"] = XMLTypeConverter::TypeToString(SystemName);
	return serList;
}

void AMT_SOAPEventSubscriber::SetValue(const XMLElement& node)
{
	string name = node.GetNodeName();
	if(name == "OtherInfoFormatDescription")
	{
		node.SetValue(OtherInfoFormatDescription);
		OtherInfoFormatDescriptionSpecified = true;
	}
	else if(name == "InfoFormat")
	{
		node.SetValue(InfoFormat);
		InfoFormatSpecified = true;
	}
	else if(name == "TimeOfLastStateChange")
	{
		node.SetValue(TimeOfLastStateChange);
		TimeOfLastStateChangeSpecified = true;
	}
	else if(name == "EnabledDefault")
	{
		node.SetValue(EnabledDefault);
		EnabledDefaultSpecified = true;
	}
	else if(name == "RequestedState")
	{
		node.SetValue(RequestedState);
		RequestedStateSpecified = true;
	}
	else if(name == "OtherEnabledState")
	{
		node.SetValue(OtherEnabledState);
		OtherEnabledStateSpecified = true;
	}
	else if(name == "EnabledState")
	{
		node.SetValue(EnabledState);
		EnabledStateSpecified = true;
	}
	else if(name == "HealthState")
	{
		node.SetValue(HealthState);
		HealthStateSpecified = true;
	}
	else if(name == "Status")
	{
		node.SetValue(Status);
		StatusSpecified = true;
	}
	else if(name == "StatusDescriptions")
	{
		node.AddValue(StatusDescriptions);
	}
	else if(name == "OperationalStatus")
	{
		node.AddValue(OperationalStatus);
	}
	else if(name == "InstallDate")
	{
		node.SetValue(InstallDate);
		InstallDateSpecified = true;
	}
	else if(name == "Caption")
	{
		node.SetValue(Caption);
		CaptionSpecified = true;
	}
	else if(name == "Description")
	{
		node.SetValue(Description);
		DescriptionSpecified = true;
	}
	else if(name == "ElementName")
	{
		node.SetValue(ElementName);
		ElementNameSpecified = true;
	}
	else if(name == "SystemCreationClassName")
	{
		node.SetValue(SystemCreationClassName);
	}
	else if(name == "SystemName")
	{
		node.SetValue(SystemName);
	}
	else if(name == "CreationClassName")
	{
		node.SetValue(CreationClassName);
	}
	else if(name == "Name")
	{
		node.SetValue(Name);
	}
	else if(name == "PortInfo")
	{
		node.SetValue(PortInfo);
		PortInfoSpecified = true;
	}
	else if(name == "PortProtocol")
	{
		node.SetValue(PortProtocol);
		PortProtocolSpecified = true;
	}
	else if(name == "OtherProtocolDescription")
	{
		node.SetValue(OtherProtocolDescription);
		OtherProtocolDescriptionSpecified = true;
	}
	else if(name == "AccessInfo")
	{
		node.SetValue(AccessInfo);
	}
	else if(name == "AccessContext")
	{
		node.SetValue(AccessContext);
		AccessContextSpecified = true;
	}
	else if(name == "OtherAccessContext")
	{
		node.SetValue(OtherAccessContext);
		OtherAccessContextSpecified = true;
	}
	else if(name == "UserName")
	{
		node.SetValue(UserName);
		UserNameSpecified = true;
	}
	else if(name == "Password")
	{
		node.SetValue(Password);
		PasswordSpecified = true;
	}
	else if(name == "AlertAuthenticationOptions")
	{
		node.AddValue(AlertAuthenticationOptions);
	}
	else if(name == "PolicyID")
	{
		node.SetValue(PolicyID);
	}
}

const string AMT_SOAPEventSubscriber::CLASS_NAME = "AMT_SOAPEventSubscriber";
const string AMT_SOAPEventSubscriber::CLASS_URI = "http://intel.com/wbem/wscim/1/amt-schema/1/AMT_SOAPEventSubscriber";
const string AMT_SOAPEventSubscriber::CLASS_NS = "http://intel.com/wbem/wscim/1/amt-schema/1/AMT_SOAPEventSubscriber";
const string AMT_SOAPEventSubscriber::CLASS_NS_PREFIX = "vxSOeg";
