# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
A test script to start a NetworkManagerState instance and print out
the current actual state of the system.
"""

from __future__ import print_function

from ubuntu_kylin_sso.networkstate import (NetworkManagerState,
                                     is_machine_connected)


def my_cb(state):
    """simple callback just prints state"""
    print("login.ubuntu.com:", state)

if __name__ == '__main__':
    # test once with direct call:
    is_machine_connected().addCallback(my_cb)

    NMS = NetworkManagerState(my_cb)

    NMS.find_online_state()

    import time
    time.sleep(60)
